/*
 * $QNXLicenseC:
 * Copyright 2015, QNX Software Systems Limited. All Rights Reserved.
 *
 * This software is QNX Confidential Information subject to
 * confidentiality restrictions. DISCLOSURE OF THIS SOFTWARE
 * IS PROHIBITED UNLESS AUTHORIZED BY QNX SOFTWARE SYSTEMS IN
 * WRITING.
 *
 * You must obtain a written license from and pay applicable license
 * fees to QNX Software Systems Limited before you may reproduce, modify
 * or distribute this software, or any work that includes all or part
 * of this software. For more information visit
 * http://licensing.qnx.com or email licensing@qnx.com.
 *
 * This file may contain contributions from others.  Please review
 * this entire file for other proprietary rights or license notices,
 * as well as the QNX Development Suite License Guide at
 * http://licensing.qnx.com/license-guide/ for other information.
 * $
 */

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/siginfo.h>
#include <unistd.h>

#include <screen/screen.h>


extern void set_display(screen_window_t screen_win, int display_id);


int
main(int argc, char **argv)
{
	screen_context_t screen_ctx = NULL;
	screen_event_t screen_ev = NULL;
	screen_window_t window = NULL;
	char idstr[64] = "hyper_id";
	int disp = 0;
	int size[2] = { 0, 0 };
	int pos[2] = { 0, 0 };
	int sensitivity = SCREEN_SENSITIVITY_ALWAYS;
	int transparency = SCREEN_TRANSPARENCY_SOURCE_OVER;
	int export_va = 0;
	int ontop = 1000;
	int visible = 1;
	int alpha = 0x1;
	const char *tok;

	int usage = SCREEN_USAGE_READ | SCREEN_USAGE_WRITE | SCREEN_USAGE_NATIVE;
	int i, rc;
	int rval = EXIT_FAILURE;

	for (i = 1; i < argc; i++) {
		if (strncmp(argv[i], "-id=", strlen("-id=")) == 0) {
			strncpy(idstr, argv[i] + strlen("-id="), sizeof(idstr) -1);
		} else if (strncmp(argv[i], "-display=", strlen("-display=")) == 0) {
			disp = atoi(argv[i] + strlen("-display="));
		} else if (strncmp(argv[i], "-sensitivity=", strlen("-sensitivity=")) == 0) {
			sensitivity = atoi(argv[i] + strlen("-sensitivity="));
		} else if (strncmp(argv[i], "-zorder=", strlen("-zorder=")) == 0) {
			ontop = atoi(argv[i] + strlen("-zorder="));
		} else if (strncmp(argv[i], "-transparency=", strlen("-transparency=")) == 0) {
			transparency = atoi(argv[i] + strlen("-transparency="));
		} else if (strncmp(argv[i], "-export=", strlen("-export=")) == 0) {
			export_va = atoi(argv[i] + strlen("-export="));
		} else if (strncmp(argv[i], "-alpha=", strlen("-alpha=")) == 0) {
			export_va = atoi(argv[i] + strlen("-alpha="));
		} else if (strncmp(argv[i], "-size=", strlen("-size=")) == 0) {
			/**
			 ** The syntax of the size option is -size=(width)x(height).
			 **/
            if (sizeof(argv[i] + strlen("-size=")) <= 7UL) {
			    tok = argv[i] + strlen("-size=");
			    size[0] = atoi(tok);
			    while (*tok >= '0' && *tok <= '9') {
				       tok++;
			    }
			    size[1] = atoi(tok+1);
            }
		} else if (strncmp(argv[i], "-pos=", strlen("-pos=")) == 0) {
			/**
			 ** The syntax of the pos option is -pos=(x),(y).
			**/

            if (sizeof(argv[i] + strlen("-size=")) <= 6UL) {
			    tok = argv[i] + strlen("-pos=");
			    pos[0] = atoi(tok);
			    while ((*tok >= '0' && *tok <= '9') || *tok == '-') {
				       tok++;
			    }
			    pos[1] = atoi(tok+1);
            }
		} else {
			fprintf(stderr, "invalid command line option: %s\n", argv[i]);
			goto fail;
		}
	}

	rc = screen_create_context(&screen_ctx, SCREEN_APPLICATION_CONTEXT);
	if (rc) {
		goto fail;
	}

	rc = screen_create_window_type(&window, screen_ctx, SCREEN_APPLICATION_WINDOW);
	if (rc) {
		goto fail;
	}

	screen_set_window_property_iv(window, SCREEN_PROPERTY_USAGE, &usage);
	rc = screen_set_window_property_cv(window, SCREEN_PROPERTY_ID_STRING, strlen(idstr), idstr);
    if (rc) {
        goto fail;
    }
	if (pos[0] != 0 || pos[1] != 0) {
		screen_set_window_property_iv(window, SCREEN_PROPERTY_POSITION, pos);
	}
	if (size[0] != 0 && size[1] != 0) {
		screen_set_window_property_iv(window, SCREEN_PROPERTY_SIZE, size);
	}

	screen_set_window_property_iv(window, SCREEN_PROPERTY_ZORDER, &ontop);
	screen_set_window_property_iv(window, SCREEN_PROPERTY_SENSITIVITY, &sensitivity);
	screen_set_window_property_iv(window, SCREEN_PROPERTY_VISIBLE, &visible);
	screen_set_window_property_iv(window, SCREEN_PROPERTY_TRANSPARENCY, &transparency);
	screen_set_window_property_iv(window, SCREEN_PROPERTY_GLOBAL_ALPHA, &alpha);

	set_display(window, disp);

	rc = screen_create_window_buffers(window, 0);
	if (rc) {
		fprintf(stderr, "vmwindow: create buffer failed \n");
		goto fail;
	}

	/* Target the permission with the pid process:1234:rwx */
	char permissions[] = "other::rwx";
	//int permission = SCREEN_PERMISSION_IROTH | SCREEN_PERMISSION_IWOTH | SCREEN_PERMISSION_IXOTH;
	if(export_va) {
		if((screen_set_window_property_cv(window, SCREEN_PROPERTY_PERMISSIONS, strlen(permissions), permissions)))
           goto fail;
	}

	rc = screen_flush_context(screen_ctx, 0);
	if (rc) {
		goto fail;
	}

	screen_buffer_t buffer = NULL;
	screen_get_window_property_pv(window, SCREEN_PROPERTY_RENDER_BUFFERS, (void **)&buffer);

	/* Put a background */
	screen_fill(screen_ctx, buffer, (const int[]) {
		SCREEN_BLIT_COLOR, 0x0000ff00,
		SCREEN_BLIT_END
	});

	/*rc = screen_post_window(window, buffer, 0, NULL, 0);
	if (rc) {
		fprintf(stderr, "vmwindow: post window failed \n");
		goto fail;
	}*/

	rc = screen_create_event(&screen_ev);
	if (rc) {
		goto fail;
	}

	for(;;) {
		int evtype = 0;
		rc = screen_get_event(screen_ctx, screen_ev, ~0);
		if (rc) {
			perror("screen_get_event");
			goto fail;
		}

		screen_get_event_property_iv(screen_ev, SCREEN_PROPERTY_TYPE, &evtype);
		if (evtype == SCREEN_EVENT_NONE) {
			break;
		}

		switch (evtype) {
			case SCREEN_EVENT_CREATE:
			case SCREEN_EVENT_CLOSE:
				//goto fail;
			case SCREEN_EVENT_POINTER:
			case SCREEN_EVENT_KEYBOARD:
			case SCREEN_EVENT_MTOUCH_TOUCH:
			case SCREEN_EVENT_MTOUCH_RELEASE:
			case SCREEN_EVENT_MTOUCH_MOVE:
			break;
		}
	}
	rval = EXIT_SUCCESS;
fail:

	if (screen_ev) {
		screen_destroy_event(screen_ev);
	}
	if (window) {
		screen_destroy_window(window);
	}
	if (screen_ctx) {
		screen_destroy_context(screen_ctx);
	}
	return rval;
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/mainline/apps/screen/tutorials/events/events.c $ $Rev: 744036 $")
#endif
